/*
 * Framework.cpp
 *
 *  Created on: Aug 17, 2012
 *      Author: linh
 */
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/time.h>
#include <algorithm>
#include <vector>
#include <sstream>
#include <string>
#include <map>
#include <queue>
#include <stack>
#include <iostream>
#include "Framework.h"

//#define CLOCKS_PER_SEC 100000
bool compare_id_pair(std::pair<int,int> first, std::pair<int,int> second) {
	return (first.first > second.first);
}

Framework::Framework(PartDatabase* partDB_): partDB(partDB_) {

}

Framework::Framework(PartDatabase* partDB_, DesignProblem dp_): partDB(partDB_), dp(dp_){

}

Framework::~Framework() {
	// TODO Auto-generated destructor stub
}

vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >* Framework::ModuleMatch(int number_of_solutions, int synthetic_module_library_size, int number_of_DB_replicates) {
	vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >* solution_list = new vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >;
	//clock_t begin, end;
	vector<Module*> *module_list;
	if (synthetic_module_library_size > 1)
		module_list = partDB->RandomizeModuleLibrary(synthetic_module_library_size, 15);
	else
		module_list = partDB->loadModuleLibrary();

	// Initialization
	GeneCircuitGraph* extension_gcg_tmp = dp.gcg.clone();
	for (int node_id = 0; node_id < extension_gcg_tmp->NodeCount(); node_id++)
		extension_gcg_tmp->GetNodeAttr(node_id)->original_node_id = node_id;
	queue<GeneCircuitGraph*> extension_history_queue;
	extension_history_queue.push(extension_gcg_tmp);
	bool continue_searching = true;
	do { // main loop on node selection & expansion
		stack<Matching_State*> traverse_history_stack;
		GeneCircuitGraph *current_extension_gcg = extension_history_queue.front();
		extension_history_queue.pop();
		GeneCircuitGraph *current_gcg = current_extension_gcg->clone();
		unsigned int current_module_id = 0;
		bool forward = true;	// to determine if the process will be forward or will be stepped back
		do { // main loop on module matching
			// TEST HERE
			// if (forward) {
			//	cout << "==============================" << endl;
			//	current_gcg->TestPrint(&std::cout);
			//}
			GraphIsomorphismCollection* all_graph_isomorphism_tmp = new GraphIsomorphismCollection;
			if (forward) {
				if (current_gcg->getNumberOfUnkownNodes() == 0) { // If current gene circuit graph == empty -> a solution is found
					//solution_list->push_back(Layout(current_gcg, partDB));
					GeneCircuitGraph* full_gcg = Layout(current_gcg, partDB);
					solution_list->push_back(std::make_pair(current_gcg->clone(), full_gcg));
					// TEST HERE
					//cout << "One solution found !" << endl;
					//cout << "==============================" << endl;
					//Layout(current_gcg, partDB)->TestPrint(&std::cout);
					forward = false;	// step back
				}
				else {
					while (all_graph_isomorphism_tmp->size() == 0 && current_module_id < module_list->size()) {
						//module_list->at(current_module_id)->TestPrint(&std::cout);
						VF2SubState vf2_sub_state(module_list->at(current_module_id), current_gcg);
						match(&vf2_sub_state, all_visitor, all_graph_isomorphism_tmp);
						current_module_id++;
					}
					//current_module_id--;	// back to the id of current module
				}
			}
			if (all_graph_isomorphism_tmp->size()) {	// match successfully
				// update the history stack
				traverse_history_stack.push(new Matching_State(current_gcg, current_module_id - 1, all_graph_isomorphism_tmp, 0));
				//current_module_id++;
			}
			else {	// step back here since we can not continue matching
				if (!traverse_history_stack.empty()) {
					if (((unsigned int)traverse_history_stack.top()->matching_id) < traverse_history_stack.top()->matching_list->size() - 1) { // try with the next matching
						// Update the history stack
						traverse_history_stack.top()->matching_id++;
						current_module_id = traverse_history_stack.top()->module_id + 1;
						free_v(current_gcg);
					}
					else { // skip this module and try with the next one
						current_module_id = traverse_history_stack.top()->module_id + 1;
						delete traverse_history_stack.top();
						traverse_history_stack.pop();							// remove the last matching
						free_v(current_gcg);
					}
				}
				else
					break;	// Finish, escape the main loop on module matching
			}
			// Update current gene circuit graph
			// Check the connection compatibility
			//		forward = true if compatible, otherwise, forward = false
			// TODO: Contract the matched subgraph into some nodes
			if (!traverse_history_stack.empty()) {
				// Update current gene circuit graph
				//cout << "---------------------------" << endl;
				//current_gcg->TestPrint(&std::cout);
				int current_module_id_tmp = traverse_history_stack.top()->module_id;
				current_gcg = traverse_history_stack.top()->gcg->clone();
				map<int,int> circuit_to_module;
				bool *is_matched = new bool [current_gcg->NodeCount()];
				for (int node_id = 0; node_id < current_gcg->NodeCount(); node_id++)
					is_matched[node_id] = false;
				// Update nodes
				for (unsigned int pair_id = 0; pair_id < traverse_history_stack.top()->matching_list->at(traverse_history_stack.top()->matching_id).size(); pair_id++) {
					NodePair node_pair_tmp = traverse_history_stack.top()->matching_list->at(traverse_history_stack.top()->matching_id)[pair_id];
					is_matched[node_pair_tmp.large_graph_node] = true;
					circuit_to_module[node_pair_tmp.large_graph_node] = node_pair_tmp.small_graph_node;
					current_gcg->GetNodeAttr(node_pair_tmp.large_graph_node)->module_id_list.push_back(current_module_id_tmp);
					// TEST HERE
					// cout << current_gcg->GetNodeAttr(node_pair_tmp.large_graph_node)->component->name << " ---> " << module_list->at(current_module_id_tmp)->GetNodeAttr(node_pair_tmp.small_graph_node)->component->name << endl;
					current_gcg->GetNodeAttr(node_pair_tmp.large_graph_node)->component->name = module_list->at(current_module_id_tmp)->GetNodeAttr(node_pair_tmp.small_graph_node)->component->name;
				}
				// Update edges
				for (int src_node_id = 0; src_node_id < current_gcg->NodeCount(); src_node_id++)
					for (int dest_node_id = 0; dest_node_id < current_gcg->NodeCount(); dest_node_id++)
						if (src_node_id != dest_node_id && is_matched[src_node_id] && is_matched[dest_node_id] && current_gcg->GetEdgeAttr(src_node_id, dest_node_id) != NULL)
							current_gcg->GetEdgeAttr(src_node_id, dest_node_id)->type = module_list->at(current_module_id_tmp)->GetEdgeAttr(circuit_to_module[src_node_id],circuit_to_module[dest_node_id])->type;
				// TEST HERE
				//if (current_module_id_tmp == 7)
				//{
				//	cout << "+++++++++++++++++++++++++++++" << endl;
				//	current_gcg->TestPrint(&std::cout);
				//}
				// Check the connection compatibility
				bool compatible = true;
				for (int src_node_id = 0; src_node_id < current_gcg->NodeCount(); src_node_id++) {
					for (int dest_node_id = 0; dest_node_id < current_gcg->NodeCount(); dest_node_id++)
						if (src_node_id != dest_node_id && current_gcg->GetEdgeAttr(src_node_id, dest_node_id) != NULL
							&& ((!is_matched[src_node_id] && is_matched[dest_node_id]) || (is_matched[src_node_id] && !is_matched[dest_node_id]))) {
								compatible = Check_Update(current_gcg, src_node_id, dest_node_id, partDB);
								if (!compatible)
									break;
						}
					if (!compatible)
						break;
				}
				if (compatible)
					forward = true;
				else {
					forward = false;
					free_v(current_gcg);
				}
				delete []is_matched;
			}
			else
				current_gcg = current_extension_gcg->clone();
		}
		while (solution_list->size() < ((unsigned int) number_of_solutions));
		if (solution_list->size() < ((unsigned int) number_of_solutions)) {
			// Choose a node and expand it
			for (int node_id = 0; node_id < current_extension_gcg->NodeCount(); node_id++) {
				int number_of_subs = partDB->getNumberOfSubsitution(Id2Str(current_extension_gcg->GetNodeAttr(node_id)->component->getType()));
				if (current_extension_gcg->GetNodeAttr(node_id)->component->name.compare("") == STR_EQ && number_of_subs > 0)
					for (int sub_id = 1; sub_id <= number_of_subs; sub_id++) {
						// Expansion here
						ARGEdit *editor_tmp = new ARGEdit;
						map<int,int> circuit_to_extension;
						// Add nodes
						for (int circuit_node_id = 0; circuit_node_id < current_extension_gcg->NodeCount(); circuit_node_id++)
							if (circuit_node_id != node_id)
								circuit_to_extension[circuit_node_id] = editor_tmp->InsertNode(current_extension_gcg->GetNodeAttr(circuit_node_id)->clone());
						// Add edges
						for (int circuit_src_node_id = 0; circuit_src_node_id < current_extension_gcg->NodeCount(); circuit_src_node_id++)
							for (int circuit_dest_node_id = 0; circuit_dest_node_id < current_extension_gcg->NodeCount(); circuit_dest_node_id++)
								if (circuit_src_node_id != node_id && circuit_dest_node_id != node_id && circuit_src_node_id != circuit_dest_node_id && current_extension_gcg->GetEdgeAttr(circuit_src_node_id, circuit_dest_node_id) != NULL)
									editor_tmp->InsertEdge(circuit_to_extension[circuit_src_node_id], circuit_to_extension[circuit_dest_node_id], current_extension_gcg->GetEdgeAttr(circuit_src_node_id, circuit_dest_node_id)->clone());
						// Expansion with the substitution
						Module *sub_gcg = partDB->loadSubstitution(Id2Str(current_extension_gcg->GetNodeAttr(node_id)->component->getType()),sub_id);
						map<int,int> sub_to_extension;
						// Add nodes
						for (int sub_node_id = 0; sub_node_id < sub_gcg->NodeCount(); sub_node_id++) {
							BioNetNode *bn_node_tmp = sub_gcg->GetNodeAttr(sub_node_id)->clone();
							bn_node_tmp->original_node_id = current_extension_gcg->GetNodeAttr(node_id)->original_node_id;
							sub_to_extension[sub_node_id] = editor_tmp->InsertNode(bn_node_tmp);
						}
						// Add edges
						for (int sub_src_node_id = 0; sub_src_node_id < sub_gcg->NodeCount(); sub_src_node_id++)
							for (int sub_dest_node_id = 0; sub_dest_node_id < sub_gcg->NodeCount(); sub_dest_node_id++)
								if (sub_src_node_id != sub_dest_node_id && sub_gcg->GetEdgeAttr(sub_src_node_id, sub_dest_node_id) != NULL)
									editor_tmp->InsertEdge(sub_to_extension[sub_src_node_id], sub_to_extension[sub_dest_node_id], sub_gcg->GetEdgeAttr(sub_src_node_id, sub_dest_node_id)->clone());
						// TODO: permute inputs and fix for the multiple output case
						// Add connections to the output
						int adj_to_output_node_id = current_extension_gcg->GetOutEdge(node_id, 0);
						editor_tmp->InsertEdge(sub_to_extension[sub_gcg->outputs[0]], circuit_to_extension[adj_to_output_node_id], current_extension_gcg->GetEdgeAttr(node_id, adj_to_output_node_id)->clone());
						// Add connections to the inputs
						int number_of_inputs = current_extension_gcg->InEdgeCount(node_id);
						if (number_of_inputs == 1) {
							int adj_to_input_node_id = current_extension_gcg->GetInEdge(node_id, 0);
							editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id], sub_to_extension[sub_gcg->inputs[0]], current_extension_gcg->GetEdgeAttr(adj_to_input_node_id, node_id)->clone());
							GeneCircuitGraph *gcg_tmp =  new GeneCircuitGraph(editor_tmp);
							// TEST HERE
							//gcg_tmp->TestPrint(&std::cout);
							extension_history_queue.push(gcg_tmp);
						}
						else if (number_of_inputs == 2) {
							int adj_to_input_node_id_0 = current_extension_gcg->GetInEdge(node_id, 0);
							int adj_to_input_node_id_1 = current_extension_gcg->GetInEdge(node_id, 1);
							editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], sub_to_extension[sub_gcg->inputs[0]], current_extension_gcg->GetEdgeAttr(adj_to_input_node_id_0, node_id)->clone());
							editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], sub_to_extension[sub_gcg->inputs[1]], current_extension_gcg->GetEdgeAttr(adj_to_input_node_id_1, node_id)->clone());
							GeneCircuitGraph *gcg_tmp1 =  new GeneCircuitGraph(editor_tmp);
							// TEST HERE
							//gcg_tmp1->TestPrint(&std::cout);
							extension_history_queue.push(gcg_tmp1);
							ARGEdit *another_editor = (ARGEdit *)gcg_tmp1->ConvertToLoader();
							another_editor->DeleteEdge(circuit_to_extension[adj_to_input_node_id_0], sub_to_extension[sub_gcg->inputs[0]]);
							another_editor->DeleteEdge(circuit_to_extension[adj_to_input_node_id_1], sub_to_extension[sub_gcg->inputs[1]]);
							another_editor->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], sub_to_extension[sub_gcg->inputs[1]], current_extension_gcg->GetEdgeAttr(adj_to_input_node_id_0, node_id)->clone());
							another_editor->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], sub_to_extension[sub_gcg->inputs[0]], current_extension_gcg->GetEdgeAttr(adj_to_input_node_id_1, node_id)->clone());
							GeneCircuitGraph *gcg_tmp2 =  new GeneCircuitGraph(another_editor);
							// TEST HERE
							//gcg_tmp2->TestPrint(&std::cout);
							extension_history_queue.push(gcg_tmp2);
						}
						else
							cout << "WE HAVE NOT PROCESSED YET FOR MODULES THAT HAVE MORE THAN TWO INPUTS " << endl;
					}
			}
		}
		else {
			continue_searching = false;	// Finish, escape the main loop on node selection & expansion
			// clear the main stack
			while (!traverse_history_stack.empty()) {
				delete traverse_history_stack.top()->gcg;
				delete traverse_history_stack.top()->matching_list;
				traverse_history_stack.pop();
			}
		}
		delete current_extension_gcg;
	}
	while (!extension_history_queue.empty() && continue_searching);
	// clear the main queue
	while (!extension_history_queue.empty()) {
		delete extension_history_queue.front();
		extension_history_queue.pop();
	}
	return solution_list;
}

vector<Molecule*>* SrcComponent2Molecule(GeneCircuitComponent *component, PartDatabase* partDB) {
	vector<Molecule*>* tmp = new vector<Molecule*>;
	if (component->getCategory() == MOLECULE)
		tmp->push_back((Molecule*) component->clone());
	else {
		Module* module_tmp = partDB->loadContent(Id2Str(component->getType()),component->name);
		for (unsigned int i = 0; i < module_tmp->inputs.size(); i++) {
			vector<Molecule*>* molecule_list_tmp  = SrcComponent2Molecule(module_tmp->GetNodeAttr(module_tmp->inputs[i])->component, partDB);
			for (unsigned int j = 0; j < molecule_list_tmp->size(); j++)
				tmp->push_back((Molecule*)molecule_list_tmp->at(j)->clone());
			delete molecule_list_tmp;
		}
		delete module_tmp;
	}
	return tmp;
}

Molecule* DestComponent2Molecule(GeneCircuitComponent *component, PartDatabase* partDB) {
	if (component->getCategory() == MOLECULE)
		return ((Molecule*) component->clone());
	else {
		Module* module_tmp = partDB->loadContent(Id2Str(component->getType()),component->name);
		GeneCircuitComponent* component_tmp = DestComponent2Molecule(module_tmp->GetNodeAttr(module_tmp->outputs[0])->component, partDB)->clone();
		delete module_tmp;
		return ((Molecule*)component_tmp);
	}
}

int Find_Regulation(GeneCircuitComponent* src, GeneCircuitComponent* dest, PartDatabase *partDB) {
	int regulation_type = UNKNOWN;
	if (src->name.length() > 0 && dest->name.length() > 0) {
		Molecule* src_mol = DestComponent2Molecule(src, partDB);
		vector<Molecule*>* dest_mol_list = SrcComponent2Molecule(dest, partDB);
		for (unsigned int i = 0; i < dest_mol_list->size(); i++) {
			int t = partDB->getRegulationType(src_mol, dest_mol_list->at(i));
			if (t != NONE) {
				regulation_type = t;
				break;
			}
		}
		if (regulation_type == UNKNOWN)
			regulation_type = NONE;
		for (unsigned int i = 0; i < dest_mol_list->size(); i++)
			delete dest_mol_list->at(i);
		delete dest_mol_list;
	}
	return regulation_type;
}

bool Check_Update(GeneCircuitGraph *gcg, int src_node_id, int dest_node_id, PartDatabase* partDB) {
	GeneCircuitComponent *src = gcg->GetNodeAttr(src_node_id)->component;
	GeneCircuitComponent *dest = gcg->GetNodeAttr(dest_node_id)->component;
	if (src->name.length() > 0 && dest->name.length() > 0) {
		Molecule* src_mol = DestComponent2Molecule(src, partDB);
		vector<Molecule*>* dest_mol_list = SrcComponent2Molecule(dest, partDB);
		bool compatible = false;
		for (unsigned int i = 0; i < dest_mol_list->size(); i++) {
			int type_1 = partDB->getRegulationType(src_mol, dest_mol_list->at(i));
			int type_2 = gcg->GetEdgeAttr(src_node_id, dest_node_id)->type;
			// TEST HERE
			//cout << src_mol->name << " " << type_1 << " " << dest_mol_list->at(i)->name
			//	<< "\t" << src_node_id << " " << type_2 << " " << dest_node_id << endl;
			if ((type_1 == type_2) || (type_1 != NONE && type_2 == UNKNOWN)) {
				compatible = true;
				break;
			}
		}
		delete dest_mol_list;
		return compatible;
	}
	// TODO: update src_mol and dest_mol
	return true;
}

GeneCircuitGraph* Layout(GeneCircuitGraph *gcg, PartDatabase* partDB) {
	GeneCircuitGraph *current_gcg = gcg->clone();
	bool continue_extending;
	do {
		continue_extending = false;
		for (int node_id = 0; node_id < current_gcg->NodeCount(); node_id++)
			if (current_gcg->GetNodeAttr(node_id)->component->getCategory() != MOLECULE) {
				Module *module_tmp = partDB->loadContent(Id2Str(current_gcg->GetNodeAttr(node_id)->component->getType()), current_gcg->GetNodeAttr(node_id)->component->name);
				GeneCircuitGraph *gcg_tmp = GeneCircuitGraphExtension(current_gcg, node_id, module_tmp, partDB);
				delete current_gcg;
				current_gcg = gcg_tmp;
				continue_extending = true;
				break;
			}
		// TEST HERE
		//cout << "***************************";
		//current_gcg->TestPrint(&std::cout);
	} while (continue_extending);
	// Update the edges that are created during the expansion step
	for (int src_id = 0; src_id < current_gcg->NodeCount(); src_id++)
		for (int dest_id = 0; dest_id < current_gcg->NodeCount(); dest_id++)
			if (src_id != dest_id) {
				BioNetEdge *bn_e = current_gcg->GetEdgeAttr(src_id, dest_id);
				if (bn_e != NULL && bn_e->type == UNKNOWN)
					bn_e->type = Find_Regulation(current_gcg->GetNodeAttr(src_id)->component, current_gcg->GetNodeAttr(dest_id)->component, partDB);
			}
	return current_gcg;
}

GeneCircuitGraph* GeneCircuitGraphExtension(GeneCircuitGraph* gcg, int sub_node_id, Module* module, PartDatabase *partDB) {
	// TEST HERE
	//module->TestPrint(&std::cout);
	ARGEdit *editor_tmp = new ARGEdit;
	map<int,int> circuit_to_extension;
	// Add nodes
	for (int i = 0; i < gcg->NodeCount(); i++)
		if (i != sub_node_id)
			circuit_to_extension[i] = editor_tmp->InsertNode(gcg->GetNodeAttr(i)->clone());
	// Add edges
	for (int i = 0; i < gcg->NodeCount(); i++)
		for (int j = 0; j < gcg->NodeCount(); j++)
			if (i != sub_node_id && j != sub_node_id && i != j && gcg->GetEdgeAttr(i,j) != NULL)
				editor_tmp->InsertEdge(circuit_to_extension[i], circuit_to_extension[j], gcg->GetEdgeAttr(i,j)->clone());
	map<int,int> module_to_extension;
	// Add nodes
	for (int i = 0; i < module->NodeCount(); i++) {
		BioNetNode *bn_node_tmp = module->GetNodeAttr(i)->clone();
		bn_node_tmp->original_node_id = gcg->GetNodeAttr(sub_node_id)->original_node_id;
		module_to_extension[i] = editor_tmp->InsertNode(bn_node_tmp);
	}
	// Add edges
	for (int i = 0; i < module->NodeCount(); i++)
		for (int j = 0; j < module->NodeCount(); j++)
			if (i != j && module->GetEdgeAttr(i,j) != NULL)
				editor_tmp->InsertEdge(module_to_extension[i], module_to_extension[j], module->GetEdgeAttr(i,j)->clone());
	// TODO: permute inputs and fix for the multiple output case
	// Add connections to the output
	int adj_to_output_node_id = gcg->GetOutEdge(sub_node_id, 0);
	editor_tmp->InsertEdge(module_to_extension[module->outputs[0]], circuit_to_extension[adj_to_output_node_id], gcg->GetEdgeAttr(sub_node_id, adj_to_output_node_id)->clone());
	// Add connections to the inputs
	int number_of_inputs = gcg->InEdgeCount(sub_node_id);
	if (number_of_inputs == 1) {
		int adj_to_input_node_id = gcg->GetInEdge(sub_node_id, 0);
		editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id], module_to_extension[module->inputs[0]], gcg->GetEdgeAttr(adj_to_input_node_id, sub_node_id)->clone());
	}
	else if (number_of_inputs == 2) {
		int adj_to_input_node_id_0 = gcg->GetInEdge(sub_node_id, 0);
		int adj_to_input_node_id_1 = gcg->GetInEdge(sub_node_id, 1);
		if (Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_0)->component, module->GetNodeAttr(module->inputs[0])->component, partDB) != NONE) {
			editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], module_to_extension[module->inputs[0]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_0)->component, module->GetNodeAttr(module->inputs[0])->component, partDB)));
			editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], module_to_extension[module->inputs[1]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_1)->component, module->GetNodeAttr(module->inputs[1])->component, partDB)));
		}
		else {
			editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], module_to_extension[module->inputs[1]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_0)->component, module->GetNodeAttr(module->inputs[1])->component, partDB)));
			editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], module_to_extension[module->inputs[0]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_1)->component, module->GetNodeAttr(module->inputs[0])->component, partDB)));
		}
	}
	else
		cout << "WE HAVE NOT PROCESSED YET FOR MODULES THAT HAVE MORE THAN TWO INPUTS " << endl;
	return new GeneCircuitGraph(editor_tmp);
}

void Framework::Scalability(int number_of_gates, int number_of_inputs, int number_of_DB_replicates, int module_library_size, int number_of_solutions) {
	bool finish;
	//clock_t begin, end;
	do {
		finish = false;
		//begin = clock();
		// Randomize topology
		dp.gcg = *(GenerateGateNetwork(number_of_gates, number_of_inputs, true));
		dp.gcg.TestPrint(&std::cout);
		break;
		ResetRunningTime();
		//finish = TopologyMatch(number_of_solutions, module_library_size, number_of_DB_replicates);
		//end = clock();
	}
	while (!finish);
	cout << getRunningTime() << "\t";
}

void Framework::Optimize() {
	vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >* solution_list = ModuleMatch(1,0);
	ARGLoader* loader = solution_list->at(0).second->ConvertToLoader();
	IdList inputs, outputs;
	for (int i = 0; i < dp.gcg.NodeCount(); i++) {
		if (dp.gcg.InEdgeCount(i) == 0)
			for (int j = 0; j < loader->NodeCount(); j++)
				if (((BioNetNode*)loader->GetNodeAttr(j))->original_node_id == i) {
					inputs.push_back(j);
					break;
				}
		if (dp.gcg.OutEdgeCount(i) == 0)
			for (int j = 0; j < loader->NodeCount(); j++)
				if (((BioNetNode*)loader->GetNodeAttr(j))->original_node_id == i) {
					outputs.push_back(j);
					break;
				}
	}

	// Build the static circuit
	Module* final_gcg = new Module(loader, inputs, outputs);
	// TEST HERE
	//	final_gcg->TestPrint(&std::cout);
	// delete solution_list;


	// Build the dynamic circuit
	DynamicGeneCircuit dgc(final_gcg);
	//delete final_gcg;
	// TEST HERE
	// dgc.PrintOut(&std::cout);

	double t0, t1;

	// Exhaustive search
	//cout << "\nExhaustive search" << endl;
	//t0 = clock();
	//dgc.ExhaustiveSearch(partDB, dp.inputs, dp.outputs);
	//t1 = clock();
	//cout << "Time: " << (t1 - t0)/(double)CLOCKS_PER_SEC << endl;


	// GA search
	cout << "GA search" << endl;
	for (int i = 0; i < 1; i++) {
		t0 = clock();
		dgc.GASearch(partDB, dp.inputs, dp.outputs);
		t1 = clock();
		cout << "Time: " << (t1 - t0)/(double)CLOCKS_PER_SEC << endl;
	}
	for (unsigned int i = 0; i < dgc.root_component->sub_component_list.size();i++)
		final_gcg->GetNodeAttr(i)->component->variant_id = dgc.root_component->sub_component_list[i]->variant_id;
	//final_gcg->TestPrint(&std::cout);
	//dgc.SimulateSteadyState(partDB,dp.inputs,dp.outputs);
	//dp.TestPrint(&std::cout);*/
	GeneCircuitGraph *gcg_tmp = solution_list->at(0).first;
	for (int i = 0; i < solution_list->at(0).first->NodeCount(); i++) {
		cout << i << "\t" << Id2Str(gcg_tmp->GetNodeAttr(i)->component->getType()) << "\t" << gcg_tmp->GetNodeAttr(i)->component->name << endl;
		for (int j = 0; j < final_gcg->NodeCount(); j++)
			if (final_gcg->GetNodeAttr(j)->original_node_id == i) {
				cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << endl;
			}
		cout << "--------------------" << endl;
	}
	delete solution_list->at(0).first;
	delete solution_list->at(0).second;
	delete solution_list;
}

bool all_visitor(int n, node_id* small_graph_node_list, node_id* large_graph_node_list, void* all_graph_isomorphism) {
	GraphIsomorphism graph_isomorphism;
	graph_isomorphism.reserve(n);
	for (int i = 0; i < n; i++){
		NodePair node_pair_tmp(small_graph_node_list[i],large_graph_node_list[i]);
		graph_isomorphism.push_back(node_pair_tmp);
	}
	((vector<GraphIsomorphism>*) all_graph_isomorphism)->push_back(graph_isomorphism);
	return false;
}
